import java.awt.*;



public class MainWindow extends Frame {




MenuBar menuBar;
Menu menu;
MenuItem exitMenuItem;


Panel        northPanel;

SouthPanel   southPanel;

NorthWestPanel northWestPanel;
NorthEastPanel northEastPanel;

HttpApplet httpApplet;




  public MainWindow( HttpApplet httpApplet ) {

 

    this. httpApplet = httpApplet;

    // Hauptpanel wird in zwei Zeilen (north- und southPanel) dividiert
    setLayout(new GridLayout(2,1));
    northPanel = new Panel();

    // northPanel wird in zwei Spalten dividiert (northWest- und 
    // northEastPanel); northWestPanel hat ein TextArea (htmlEDitor) und 
    // northEastPanel hat die drei Buttons und die beiden Bilder
    northPanel. setLayout(new GridLayout(1,2));
    northWestPanel = new NorthWestPanel();
    northEastPanel = new NorthEastPanel( this, httpApplet );
    northPanel. add(northWestPanel);
    northPanel. add(northEastPanel);
    add(northPanel);


    //southPanel enthaelt nur ein historyPanel von der HistoryPanel Klasse
    // und einen Scrollbar
    southPanel = new SouthPanel(this);
    add(southPanel);


    // Fuege MenuBar hinzu
    menuBar = new MenuBar();
    setMenuBar(menuBar);
    menu = new Menu("Applet");
    menu. setFont( new Font("Helvetica", Font. BOLD, 12));
    menuBar. add(menu);
    exitMenuItem = new MenuItem("Exit         ");
    menu. add(exitMenuItem);

    // Titel des Fensters
    setTitle("WWW Visualisation");

    validate(); // validate layout
  }





  public boolean handleEvent(Event e) {

 
    Font font;

    //       System.out.println(e);

    if ( e. id == Event. ACTION_EVENT ) {

      if ( e. target == exitMenuItem ) {

	dispose();
	return true;
      }
    }

    if ( e. id == Event. WINDOW_MOVED ) {

      Font htmlEditorFont = new Font( "Helvetica", Font. PLAIN, 12 );

      if ( size(). width < 800) {
	
	htmlEditorFont = new Font( "Helvetica", Font. PLAIN, 12);
	northWestPanel. htmlEditor. setFont( htmlEditorFont );
      }
                  
      if ( 800 <= size().width & size(). width < 900) {
	
	htmlEditorFont = new Font( "Helvetica", Font. PLAIN, 14);
	northWestPanel. htmlEditor. setFont( htmlEditorFont );
      }

      if ( 900 <= size().width & size(). width < 1000) {
	
	htmlEditorFont = new Font( "Helvetica", Font. PLAIN, 17);
	northWestPanel. htmlEditor. setFont( htmlEditorFont );
      }

      if ( 1000 <= size().width & size(). width < 1100) {
	
	htmlEditorFont = new Font( "Helvetica", Font. PLAIN, 18);
	northWestPanel. htmlEditor. setFont( htmlEditorFont );
      }

      if ( 1100 <= size().width  & size(). width < 1200 ) {
	
	htmlEditorFont = new Font( "Helvetica", Font. PLAIN, 22);
	northWestPanel. htmlEditor. setFont( htmlEditorFont );
      }

      if ( size().width >= 1200 ) {
	
	htmlEditorFont = new Font( "Helvetica", Font. PLAIN, 24);
	northWestPanel. htmlEditor. setFont( htmlEditorFont );
      }
      
    }
    
    return super. handleEvent(e);
  }




}




